﻿using Microsoft.AspNetCore.Mvc;
using MvcSample.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace MvcSample.ViewComponents
{
    public class SideBarViewComponent : ViewComponent
    {
        private readonly ILinkRepository db;
        public SideBarViewComponent(ILinkRepository repository)
        {
            db = repository;
        }

        public IViewComponentResult Invoke(int max = 10)
        {
            var items = db.GetLinks().Take(max);
            return View(items);
        }
    }
}
